/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalSVG = Object.create(STBModule.prototype);

STBGlobalSVG.name = "GlobalSVG";

STBGlobalSVG.initIcons = function() {

	var elements = jQuery(".icon.svgicon:empty:not(.__done_icon)");


	if (elements.length){
		elements.each(function () {
			var obj = jQuery(this),
				data = obj.attr("class");
				path = STBUtils.str_replace("icon" , "" , STBUtils.str_replace("svgicon" , "" , data)).trim();

			obj.append("<img class=\"icon-set-img\" src=\"assets/svgicons/" + path + ".svg\"/>");
		});
	}

	elements.addClass("__done_icon");

}


STBGlobalSVG.initPlugin = function () {

	var elements = jQuery('img[src*=".svg"].load-inline');

	//console.log(elements);

	if (elements.length) {
		elements.each(function() {

            var img = jQuery(this);
            var imgID = img.attr('id');
            var imgClass = img.attr('class');
            var imgURL = img.attr('src');

			if (imgURL.indexOf("svgicons") === -1) {

				jQuery.get(imgURL, function(data) {
					// Get the SVG tag, ignore the rest
					var svg = jQuery(data).find('svg');

					// Add replaced image's ID to the new SVG
					if(typeof imgID !== 'undefined') {
						svg = svg.attr('id', imgID);
					}
					// Add replaced image's classes to the new SVG
					if(typeof imgClass !== 'undefined') {
						svg = svg.attr('class', imgClass+' replaced-svg');
					}

					// Remove any invalid XML tags as per http://validator.w3.org
					svg = svg.removeAttr('xmlns:a');

					// Replace image with new SVG
					img.replaceWith(svg);

				}, 'xml');
			}

		});
	}
}


STBGlobalSVG.runOnReady = function() {
	STBGlobalSVG.initIcons();
	STBGlobalSVG.initPlugin();
}


STBGlobalSVG.runOnContentUpdate = function() {
	STBGlobalSVG.initIcons();
	STBGlobalSVG.initPlugin();
}

site.registerModule(STBGlobalSVG);